﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.SharePoint;

class Program
{
   static void Main(string[] args)
   {
      using (SPSite site = new SPSite("http://contoso.de"))
      {
         using (SPWeb web = site.OpenWeb())
         {
            // Hole die Artikelreferenz
            SPList listArticle = web.Lists.TryGetList("Artikel");
            SPListItem anyArticle = listArticle.GetItemById(1);

            // Hole eine Referenz der Bestellliste
            SPList listOrders = web.Lists.TryGetList("Bestellungen");

            // Hole ein bestimmte Bestellung
            SPQuery query = new SPQuery();
            query.Query = String.Concat(
               "<Where>",
               "<Eq>",
               "<FieldRef Name='Title'/>",
               "<Value Type='Text'>",
               "ead49f69-452d-4915-abc9-22c866c7c19e",
               "</Value>",
               "</Eq>",
               "</Where>");

            query.RowLimit = 1;

            SPListItemCollection allItems = listOrders.GetItems(query);
            SPListItem item = null;

            if (allItems != null && allItems.Count > 0)
            {
               item = allItems[0];

               // Ändere den Artikel und die Menge der Bestellung
               item["Artikel"] = anyArticle.ID;
               item["Menge"] = 5;

               item.Update();               

               Console.WriteLine("Element aktualisiert: {0} ({1})",
               item.Title, item["Modified"].ToString());
            }
         }
      }
   }
}

